<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Node extends Model 
{

    protected $table = 'node';
    public $timestamps = true;
    protected $fillable = array('core_id', 'library_storage_id');

    public function campaigns()
    {
        return $this->hasMany('App\Models\Campaign');
    }

    public function componentPlaylists()
    {
        return $this->hasMany('App\Models\ComponentPlaylist');
    }

    public function componentPrograms()
    {
        return $this->hasMany('App\Models\ComponentProgram');
    }

    public function contents()
    {
        return $this->hasMany('App\Models\Content');
    }

    public function contentUpdates()
    {
        return $this->hasMany('App\Models\ContentUpdate');
    }

    public function libraryCategories()
    {
        return $this->hasMany('App\Models\LibraryCategory');
    }

    public function libraryFiles()
    {
        return $this->hasMany('App\Models\LibraryFile');
    }

    public function streams()
    {
        return $this->hasMany('App\Models\Stream');
    }

    public function LibraryStorage()
    {
        return $this->belongsTo('App\Models\LibraryStorage');
    }

}